IF OBJECT_ID('dbo.P_PROCESSA_IMPORTA_CUSTO_MEDIO', 'P') IS NOT NULL
    DROP PROCEDURE dbo.P_PROCESSA_IMPORTA_CUSTO_MEDIO
GO

CREATE PROCEDURE dbo.P_PROCESSA_IMPORTA_CUSTO_MEDIO
    @CD_CTR INT
AS
BEGIN
    SET NOCOUNT ON;
    SET XACT_ABORT ON; -- Garantir rollback automtico em erro

    BEGIN TRY
        BEGIN TRANSACTION;

        DECLARE @CD_EMP INT,
                @CD_FILIAL INT,
                @DT_MOVTO DATETIME,
                @CD_PROD INT,
                @VL_CUSTO MONEY,
                @CD_USU INT;

        -- Limpa registros processados h mais de 30 dias
        DELETE FROM dbo.IMPORTA_CUSTO_MEDIO
        WHERE STS_IMPORTACAO = 1
          AND DT_CADASTRO < DATEADD(DAY, -30, GETDATE());

        -- Cursor para percorrer registros 
        DECLARE curCustos CURSOR LOCAL FAST_FORWARD FOR
            SELECT CD_EMP, CD_FILIAL, DT_MOVTO, CD_PROD, VL_CUSTO, CD_USU
            FROM dbo.IMPORTA_CUSTO_MEDIO
            WHERE STS_IMPORTACAO = 0
              AND CD_CTR = @CD_CTR
            ORDER BY CD_EMP, CD_FILIAL;

        OPEN curCustos;
        FETCH NEXT FROM curCustos INTO @CD_EMP, @CD_FILIAL, @DT_MOVTO, @CD_PROD, @VL_CUSTO, @CD_USU;

        WHILE @@FETCH_STATUS = 0
        BEGIN
            -- Chama a procedure existente passando o CD_CTR
            EXEC dbo.P_EST_PROD_CPL_ACERTO_CUSTO_CORRECAO 
                 @CD_EMP, @CD_FILIAL, @DT_MOVTO, @CD_PROD, @VL_CUSTO, @CD_USU, @CD_CTR;

            FETCH NEXT FROM curCustos INTO @CD_EMP, @CD_FILIAL, @DT_MOVTO, @CD_PROD, @VL_CUSTO, @CD_USU;
        END

        CLOSE curCustos;
        DEALLOCATE curCustos;

        -- Atualiza STS_IMPORTACAO para 1 apenas para registros do CD_CTR 
        UPDATE dbo.IMPORTA_CUSTO_MEDIO
        SET STS_IMPORTACAO = 1
        WHERE STS_IMPORTACAO = 0
          AND CD_CTR = @CD_CTR;

        COMMIT TRANSACTION;
    END TRY
    BEGIN CATCH
        IF XACT_STATE() <> 0
            ROLLBACK TRANSACTION;

        DECLARE @ErrMsg NVARCHAR(4000) = ERROR_MESSAGE();
        DECLARE @ErrNum INT = ERROR_NUMBER();

        RAISERROR('Erro ao processar IMPORTA_CUSTO_MEDIO. Cdigo: %d, Mensagem: %s', 16, 1, @ErrNum, @ErrMsg);
    END CATCH
END
GO
